<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('category_id');
			$table->string('name');
			$table->double('price');
			$table->enum('status', array('deactivate', 'active'));
			$table->text('description')->nullable();
			$table->integer('quantity_order')->nullable()->default('0');
			$table->string('dimension');
			$table->integer('store_id')->default('1');
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}