<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonEmployeeTable extends Migration {

	public function up()
	{
		Schema::create('person_employee', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('department_id');
			$table->integer('team_id');
			$table->integer('job_title_id');
			$table->string('employee_no', 50);
			$table->string('employee_code', 50);
			$table->date('date_joined');
			$table->integer('tax_status_id');
			$table->string('tax_number', 50);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('person_employee');
	}
}