<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonTable extends Migration {

	public function up()
	{
		Schema::create('person', function(Blueprint $table) {
			$table->increments('id');
			$table->string('initials', 10);
			$table->string('first_name', 100);
			$table->string('surname', 100);
			$table->date('birth_date');
			$table->string('known_as', 50);
			$table->integer('marital_status_id')->unsigned();
			$table->string('spouse_full_name', 50);
			$table->integer('gender_id');
			$table->integer('title_id');
			$table->string('id_number', 30);
			$table->integer('language_id');
			$table->morphs('personable');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('person');
	}
}