<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('payment_method', array('online', 'cash_on_delivery'));
			$table->string('transaction_id')->unique();
			$table->enum('status', array('pending', 'completed', 'failed'));
			$table->integer('order_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}