<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserChannelsTable extends Migration {

	public function up()
	{
		Schema::create('user_channels', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('status')->nullable();
			$table->integer('user_id')->unsigned();
			$table->integer('channel_id')->unsigned();
			$table->string('name', 250)->nullable();
			$table->string('link', 500)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('user_channels');
	}
}