<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Mensaje extends Model 
{

    protected $table = 'mensajes';
    public $timestamps = true;
    protected $fillable = array('emisor_id');

    public function emisor()
    {
        return $this->belongsTo('Identidad', 'emisor_id');
    }

    public function envios()
    {
        return $this->hasMany('Envio');
    }

    public function adjuntos()
    {
        return $this->hasMany('Adjunto', 'mensaje_id');
    }

    public function plataforma()
    {
        return $this->belongsTo('Plataforma');
    }

}