<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('procesos', function(Blueprint $table) {
			$table->foreign('accion_id')->references('id')->on('acciones')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('procesos', function(Blueprint $table) {
			$table->foreign('producto_id')->references('id')->on('productos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('productos', function(Blueprint $table) {
			$table->foreign('tienda_id')->references('id')->on('tiendas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('ofertas', function(Blueprint $table) {
			$table->foreign('tienda_id')->references('id')->on('tiendas')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('producto_oferta', function(Blueprint $table) {
			$table->foreign('producto_id')->references('id')->on('productos')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('producto_oferta', function(Blueprint $table) {
			$table->foreign('oferta_id')->references('id')->on('ofertas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('credenciales', function(Blueprint $table) {
			$table->foreign('producto_id')->references('id')->on('productos')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('credenciales', function(Blueprint $table) {
			$table->foreign('licencia_id')->references('id')->on('licencias')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('licencias', function(Blueprint $table) {
			$table->foreign('prescripcion_id')->references('id')->on('prescripciones')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('licencias', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('prescripciones', function(Blueprint $table) {
			$table->foreign('oferta_id')->references('id')->on('ofertas')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('prescripciones', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('identidades', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('mensajes', function(Blueprint $table) {
			$table->foreign('plataforma_id')->references('id')->on('plataformas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('mensajes', function(Blueprint $table) {
			$table->foreign('emisor_id')->references('id')->on('identidades')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('perfiles', function(Blueprint $table) {
			$table->foreign('usuario_id')->references('id')->on('usuarios')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('perfiles', function(Blueprint $table) {
			$table->foreign('rol_id')->references('id')->on('roles')
						->onDelete('set null')
						->onUpdate('set null');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->foreign('mensaje_id')->references('id')->on('mensajes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->foreign('receptor_id')->references('id')->on('identidades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('adjuntos', function(Blueprint $table) {
			$table->foreign('mensaje_id')->references('id')->on('mensajes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notificaciones', function(Blueprint $table) {
			$table->foreign('identidad_id')->references('id')->on('identidades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alertas', function(Blueprint $table) {
			$table->foreign('plataforma_id')->references('id')->on('plataformas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alertas', function(Blueprint $table) {
			$table->foreign('identidad_id')->references('id')->on('identidades')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('criterios', function(Blueprint $table) {
			$table->foreign('plataforma_id')->references('id')->on('plataformas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('eventos', function(Blueprint $table) {
			$table->foreign('plataforma_id')->references('id')->on('plataformas')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('procesos', function(Blueprint $table) {
			$table->dropForeign('procesos_accion_id_foreign');
		});
		Schema::table('procesos', function(Blueprint $table) {
			$table->dropForeign('procesos_producto_id_foreign');
		});
		Schema::table('productos', function(Blueprint $table) {
			$table->dropForeign('productos_tienda_id_foreign');
		});
		Schema::table('ofertas', function(Blueprint $table) {
			$table->dropForeign('ofertas_tienda_id_foreign');
		});
		Schema::table('producto_oferta', function(Blueprint $table) {
			$table->dropForeign('producto_oferta_producto_id_foreign');
		});
		Schema::table('producto_oferta', function(Blueprint $table) {
			$table->dropForeign('producto_oferta_oferta_id_foreign');
		});
		Schema::table('credenciales', function(Blueprint $table) {
			$table->dropForeign('credenciales_producto_id_foreign');
		});
		Schema::table('credenciales', function(Blueprint $table) {
			$table->dropForeign('credenciales_licencia_id_foreign');
		});
		Schema::table('licencias', function(Blueprint $table) {
			$table->dropForeign('licencias_prescripcion_id_foreign');
		});
		Schema::table('licencias', function(Blueprint $table) {
			$table->dropForeign('licencias_usuario_id_foreign');
		});
		Schema::table('prescripciones', function(Blueprint $table) {
			$table->dropForeign('prescripciones_oferta_id_foreign');
		});
		Schema::table('prescripciones', function(Blueprint $table) {
			$table->dropForeign('prescripciones_usuario_id_foreign');
		});
		Schema::table('identidades', function(Blueprint $table) {
			$table->dropForeign('identidades_usuario_id_foreign');
		});
		Schema::table('mensajes', function(Blueprint $table) {
			$table->dropForeign('mensajes_plataforma_id_foreign');
		});
		Schema::table('mensajes', function(Blueprint $table) {
			$table->dropForeign('mensajes_emisor_id_foreign');
		});
		Schema::table('perfiles', function(Blueprint $table) {
			$table->dropForeign('perfiles_usuario_id_foreign');
		});
		Schema::table('perfiles', function(Blueprint $table) {
			$table->dropForeign('perfiles_rol_id_foreign');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->dropForeign('envios_mensaje_id_foreign');
		});
		Schema::table('envios', function(Blueprint $table) {
			$table->dropForeign('envios_receptor_id_foreign');
		});
		Schema::table('adjuntos', function(Blueprint $table) {
			$table->dropForeign('adjuntos_mensaje_id_foreign');
		});
		Schema::table('notificaciones', function(Blueprint $table) {
			$table->dropForeign('notificaciones_identidad_id_foreign');
		});
		Schema::table('alertas', function(Blueprint $table) {
			$table->dropForeign('alertas_plataforma_id_foreign');
		});
		Schema::table('alertas', function(Blueprint $table) {
			$table->dropForeign('alertas_identidad_id_foreign');
		});
		Schema::table('criterios', function(Blueprint $table) {
			$table->dropForeign('criterios_plataforma_id_foreign');
		});
		Schema::table('eventos', function(Blueprint $table) {
			$table->dropForeign('eventos_plataforma_id_foreign');
		});
	}
}