<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('visitas', function(Blueprint $table) {
			$table->foreign('tipoVisitaId')->references('id')->on('tipoVisita')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('tramites', function(Blueprint $table) {
			$table->foreign('tipoTramiteId')->references('id')->on('tipoTramite')
						->onDelete('no action')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('visitas', function(Blueprint $table) {
			$table->dropForeign('visitas_tipoVisitaId_foreign');
		});
		Schema::table('tramites', function(Blueprint $table) {
			$table->dropForeign('tramites_tipoTramiteId_foreign');
		});
	}
}