<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class InvoicePayment extends Model 
{

    protected $table = 'invoice_payments';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('invoice_id', 'patient_id', 'amount', 'date', 'notes');

    public function invoice()
    {
        return $this->hasMany('Models\Invoice', 'invoice_id');
    }

}