<?php

namespace App\Models;

class Store extends Eloquent {

	protected $table = 'stores';
	public $timestamps = true;
	protected $fillable = array('user_id', 'name', 'shipping_cost', 'vat_included', 'vat_percentage');

	public function user()
	{
		return $this->belongsTo('App\Models\User');
	}

	public function products()
	{
		return $this->hasMany('App\Models\Product');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\Order');
	}

}