<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Places extends Model 
{

    protected $table = 'places';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function type()
    {
        return $this->belongsTo('TypePlaces', 'id_type_place');
    }

    public function country()
    {
        return $this->belongsTo('Countries');
    }

    public function province()
    {
        return $this->belongsTo('Provinces');
    }

}