<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('id_type_place')->references('id_type_place')->on('type_places')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('provinces', function(Blueprint $table) {
			$table->foreign('id_country')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('geo_places', function(Blueprint $table) {
			$table->foreign('id_place')->references('id_place')->on('places')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gallery_schedule', function(Blueprint $table) {
			$table->foreign('id_schedule')->references('id_place')->on('schedule')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('schedule', function(Blueprint $table) {
			$table->foreign('id_place')->references('id_place')->on('places')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('schedule', function(Blueprint $table) {
			$table->foreign('id_type_activity')->references('id')->on('type_activity')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('schedule', function(Blueprint $table) {
			$table->foreign('id_location')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('id_place')->references('id_place')->on('places')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('id_type_activity')->references('id')->on('type_activity')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gallery_location', function(Blueprint $table) {
			$table->foreign('id_location')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_id_type_place_foreign');
		});
		Schema::table('provinces', function(Blueprint $table) {
			$table->dropForeign('provinces_id_country_foreign');
		});
		Schema::table('geo_places', function(Blueprint $table) {
			$table->dropForeign('geo_places_id_place_foreign');
		});
		Schema::table('gallery_schedule', function(Blueprint $table) {
			$table->dropForeign('gallery_schedule_id_schedule_foreign');
		});
		Schema::table('schedule', function(Blueprint $table) {
			$table->dropForeign('schedule_id_place_foreign');
		});
		Schema::table('schedule', function(Blueprint $table) {
			$table->dropForeign('schedule_id_type_activity_foreign');
		});
		Schema::table('schedule', function(Blueprint $table) {
			$table->dropForeign('schedule_id_location_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_id_place_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_id_type_activity_foreign');
		});
		Schema::table('gallery_location', function(Blueprint $table) {
			$table->dropForeign('gallery_location_id_location_foreign');
		});
	}
}