<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePlacesTable extends Migration {

	public function up()
	{
		Schema::create('places', function(Blueprint $table) {
			$table->increments('id_place');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 255)->index();
			$table->integer('id_type_place')->unsigned();
			$table->string('hashtag', 255)->index();
			$table->integer('id_province');
			$table->integer('id_country');
		});
	}

	public function down()
	{
		Schema::drop('places');
	}
}