<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserSessionsTable extends Migration {

	public function up()
	{
		Schema::create('user_sessions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->bigInteger('user_id')->unsigned();
			$table->string('device_id')->unique();
			$table->decimal('lat');
			$table->string('refresh_token');
			$table->boolean('is_active');
			$table->string('device_name');
			$table->string('ip_address');
			$table->string('platform_os');
			$table->string('long');
		});
	}

	public function down()
	{
		Schema::drop('user_sessions');
	}
}