<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateApartmentsTable extends Migration {

	public function up()
	{
		Schema::create('apartments', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255)->nullable();
			$table->integer('door_number')->nullable();
			$table->string('address', 260)->nullable();
			$table->string('block', 15)->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('apartments');
	}
}