<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ServiceCompte extends Model 
{

    protected $table = 'services_comptes';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function compte()
    {
        return $this->belongsTo('Compte', 'compte');
    }

    public function serviceFinancier()
    {
        return $this->belongsTo('ServiceFinancier', 'service_financier');
    }

}