<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDocumentsTable extends Migration {

	public function up()
	{
		Schema::create('documents', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->enum('type', array('Cartenationaled'identité', 'Passeport', 'Permisderesidence'));
			$table->string('documentNumber', 255);
			$table->date('dateDelivrance');
			$table->date('dateExpiration')->nullable();
			$table->string('placeOflssue', 255)->nullable();
			$table->integer('countryoflssue')->unsigned()->nullable();
			$table->integer('compte')->unsigned()->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('documents');
	}
}