<?php

namespace Main\Models\Customer;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Customer extends Eloquent {

	protected $table = 'customers';
	public $timestamps = false;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('customer_type', 'name', 'nickname', 'email', 'cpf_cnpj', 'rg_ie', 'phone', 'active');
	protected $visible = array('customer_type', 'name', 'nickname', 'cpf_cnpj', 'rg_ie', 'phone', 'active');

	public function address()
	{
		return $this->hasOne('Address', 'customer_id');
	}

	public function deliveryAddresses()
	{
		return $this->hasMany('DeliveryAddress');
	}

}