<?php

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('customer_id', 'zipcode', 'street', 'number', 'district', 'city', 'state', 'note', 'payment_method');
	protected $visible = array('customer_id', 'zipcode', 'street', 'number', 'district', 'city', 'state', 'note', 'payment_method');

	public function status()
	{
		return $this->hasMany('OrderStatus');
	}

	public function paymentSlip()
	{
		return $this->hasMany('PaymentSlip');
	}

}