<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTimerSettingsTable extends Migration {

	public function up()
	{
		Schema::create('timer_settings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->enum('type', array('motor', 'fan', 'lamp', 'sprinkler'));
			$table->string('name');
			$table->enum('timer_type', array('interval', 'timer'));
		});
	}

	public function down()
	{
		Schema::drop('timer_settings');
	}
}