<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('slug_id')->references('id')->on('slugs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('page_sections', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('page_sections', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('form_inputs', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->foreign('form_id')->references('id')->on('forms')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->foreign('section_id')->references('id')->on('sections')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('metadata', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('submission_data', function(Blueprint $table) {
			$table->foreign('form_submission_id')->references('id')->on('form_submissions')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_slug_id_foreign');
		});
		Schema::table('page_sections', function(Blueprint $table) {
			$table->dropForeign('page_sections_page_id_foreign');
		});
		Schema::table('page_sections', function(Blueprint $table) {
			$table->dropForeign('page_sections_section_id_foreign');
		});
		Schema::table('form_inputs', function(Blueprint $table) {
			$table->dropForeign('form_inputs_form_id_foreign');
		});
		Schema::table('form_submissions', function(Blueprint $table) {
			$table->dropForeign('form_submissions_form_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_country_id_foreign');
		});
		Schema::table('jobs', function(Blueprint $table) {
			$table->dropForeign('jobs_section_id_foreign');
		});
		Schema::table('metadata', function(Blueprint $table) {
			$table->dropForeign('metadata_page_id_foreign');
		});
		Schema::table('submission_data', function(Blueprint $table) {
			$table->dropForeign('submission_data_form_submission_id_foreign');
		});
	}
}