<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEmployeesTable extends Migration {

	public function up()
	{
		Schema::create('employees', function(Blueprint $table) {
			$table->increments('id');
			$table->string('image')->nullable();
			$table->string('identification_number', 10);
			$table->integer('nationality_id')->unsigned();
			$table->string('first_name', 60);
			$table->string('second_name', 60);
			$table->string('third_name', 60);
			$table->string('last_name', 60);
			$table->string('phone');
			$table->date('identity_date');
			$table->string('identity_source');
			$table->date('date_of_birth');
			$table->enum('marital_status', array('single', 'married', 'separated', 'widowed'));
			$table->string('email');
			$table->enum('gender', array('male', 'female'));
			$table->string('qualification');
			$table->string('address');
			$table->integer('employee_job_information_id')->unsigned();
			$table->timestamp('deactivated_at')->nullable();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('employees');
	}
}