<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateReceptionReportsTable extends Migration {

	public function up()
	{
		Schema::create('reception_reports', function(Blueprint $table) {
			$table->increments('id');
			$table->string('title', 150);
			$table->integer('management_id')->unsigned();
			$table->text('description');
			$table->enum('status', array(''));
			$table->datetime('date');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('reception_reports');
	}
}