<?php

namespace App\Models\User\Request;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Request extends Eloquent {

	protected $table = 'user_request_request';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function request()
	{
		return $this->belongsToMany('App\Models\User\Request2', 'user_request_id');
	}

	public function contributors()
	{
		return $this->belongsToMany('App\Models\User', 'user_id');
	}

}