<?php

namespace App\Models\User;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Role extends Eloquent {

	protected $table = 'user_role';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function users()
	{
		return $this->belongsToMany('App\Models\User');
	}

	public function acl()
	{
		return $this->belongsToMany('App\Models\User\Role\Acl');
	}

}