<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBlogPostsTable extends Migration {

	public function up()
	{
		Schema::create('blog_posts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('title', 2000);
			$table->text('content');
			$table->string('meta_keyword', 5000)->nullable();
			$table->string('meta_description', 10000)->nullable();
			$table->integer('blog_category_id')->unsigned();
			$table->integer('created_by')->unsigned();
			$table->string('summary', 10000)->nullable();
			$table->integer('updated_by')->unsigned()->nullable();
			$table->integer('blog_category_id')->unsigned();
			$table->integer('media_id')->unsigned();
			$table->string('slug', 1000);
			$table->enum('status', array('draft', 'publish'));
			$table->boolean('allow_comments')->default(true);
			$table->boolean('is_featured')->default(false);
		});
	}

	public function down()
	{
		Schema::drop('blog_posts');
	}
}