<?php

namespace App\Models;

class Order extends Eloquent {

	protected $table = 'orders';
	public $timestamps = true;
	protected $fillable = array('payment_method_id', 'total', 'delivery_cost', 'price', 'note', 'delivery_address', 'commission', 'client_id');

	public function resturant()
	{
		return $this->belongsTo('App\Models\Resturant');
	}

	public function items()
	{
		return $this->belongsToMany('App\Models\Item');
	}

	public function payment-method()
	{
		return $this->belongsTo('App\Models\PaymentMethod');
	}

	public function client()
	{
		return $this->belongsTo('App\Models\Client');
	}

}