<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('productos', function(Blueprint $table) {
			$table->foreign('categoria_id')->references('id')->on('categorias')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('compras', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('producto_compra', function(Blueprint $table) {
			$table->foreign('producto_id')->references('id')->on('productos')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('producto_compra', function(Blueprint $table) {
			$table->foreign('compra_id')->references('id')->on('compras')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('productos', function(Blueprint $table) {
			$table->dropForeign('productos_categoria_id_foreign');
		});
		Schema::table('compras', function(Blueprint $table) {
			$table->dropForeign('compras_user_id_foreign');
		});
		Schema::table('producto_compra', function(Blueprint $table) {
			$table->dropForeign('producto_compra_producto_id_foreign');
		});
		Schema::table('producto_compra', function(Blueprint $table) {
			$table->dropForeign('producto_compra_compra_id_foreign');
		});
	}
}