<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Branch extends Model 
{

    protected $table = 'branches';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function room()
    {
        return $this->hasMany('\Room');
    }

    public function doctor()
    {
        return $this->hasMany('DoctorBranch');
    }

    public function product()
    {
        return $this->hasMany('BranchProductStock');
    }

}