<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTeamsTable extends Migration {

	public function up()
	{
		Schema::create('teams', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->index();
			$table->integer('league_id')->index();
			$table->string('name');
			$table->boolean('active')->default(true);
			$table->string('stadium')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('teams');
	}
}