<?php

namespace App\Models;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;
	protected $fillable = array('price', 'image', 'quantity', 'seq', 'status');

	public function brand()
	{
		return $this->belongsTo('App\Models\Brand');
	}

	public function category()
	{
		return $this->belongsTo('App\Models\Category');
	}

	public function productImage()
	{
		return $this->hasMany('App\Models\ProductImage');
	}

}