<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('first_name', 'last_name', 'password', 'phone', 'email', 'city_id', 'status', 'code', 'image', 'api_token');

	public function city()
	{
		return $this->belongsTo('App\Models\City');
	}

	public function orders()
	{
		return $this->hasMany('App\Models\User');
	}

	public function cartitems()
	{
		return $this->hasMany('App\Models\CartItem');
	}

	public function addresses()
	{
		return $this->hasMany('App\Models\UserAddress');
	}

}