<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Package_Product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('Product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('Package_Product', function(Blueprint $table) {
			$table->foreign('package_id')->references('id')->on('Package')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('PackageFeatures', function(Blueprint $table) {
			$table->foreign('package_product_id')->references('id')->on('Package_Product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('Package_Product', function(Blueprint $table) {
			$table->dropForeign('Package_Product_product_id_foreign');
		});
		Schema::table('Package_Product', function(Blueprint $table) {
			$table->dropForeign('Package_Product_package_id_foreign');
		});
		Schema::table('PackageFeatures', function(Blueprint $table) {
			$table->dropForeign('PackageFeatures_package_product_id_foreign');
		});
	}
}