<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSalaryReviewTable extends Migration {

	public function up()
	{
		Schema::create('salary_review', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('employee_id')->unsigned();
			$table->boolean('requested');
			$table->date('salary_review_date');
			$table->bigInteger('amount');
			$table->text('comment');
			$table->date('requested_date');
			$table->bigInteger('requested_review');
			$table->text('requested_arguments');
			$table->text('request_reply');
		});
	}

	public function down()
	{
		Schema::drop('salary_review');
	}
}