<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePersonsTable extends Migration {

	public function up()
	{
		Schema::create('persons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('firstName', 100);
			$table->string('lastName', 100);
			$table->string('secondLastName', 100)->nullable();
			$table->tinyInteger('isActive')->default('1');
			$table->datetime('lastLogin');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('persons');
	}
}