<?php

class Person extends Eloquent {

	protected $table = 'persons';
	public $timestamps = true;

	public function user()
	{
		return $this->hasOne('User', 'idPerson', 'id');
	}

	public function companys()
	{
		return $this->belongsToMany('Company', 'company_users', 'idPerson', 'idCompany');
	}

	public function vacancies_created()
	{
		return $this->hasMany('Vacancy', 'idCreator');
	}

	public function vacancies_tracked()
	{
		return $this->hasMany('Vacancy', 'idRecruiter');
	}

	public function applied_to()
	{
		return $this->belongsToMany('Vacancy_published', 'applicants', 'idApplicant', 'idPublication');
	}

	public function professional_experience()
	{
		return $this->hasMany('Professional_experience', 'idPerson', 'id');
	}

	public function academic_studies()
	{
		return $this->hasMany('Academic_studies', 'idPerson', 'id');
	}

	public function courses()
	{
		return $this->hasOne('Courses', 'idPerson', 'id');
	}

	public function languages()
	{
		return $this->hasOne('Person_languages', 'idPerson', 'id');
	}

}