<?php

class User extends Eloquent {

	protected $table = 'users';
	public $timestamps = true;

	public function person()
	{
		return $this->belongsTo('Person', 'idPerson');
	}

	public function roles()
	{
		return $this->belongsToMany('Role', 'users_roles', 'idUser', 'idRole');
	}

	public function hybridauth()
	{
		return $this->hasOne('Hybridauth_user', 'idUser', 'id');
	}

	public function scopes()
	{
		return $this->hasMany('Scope', 'idUser', 'id');
	}

}