<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('urls', function(Blueprint $table) {
			$table->foreign('domain_sitemap_id')->references('id')->on('domain_sitemap')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('scan_scheduler', function(Blueprint $table) {
			$table->foreign('domain_sitemap_id')->references('id')->on('domain_sitemap')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('domain_sitemap', function(Blueprint $table) {
			$table->foreign('domain_id')->references('id')->on('domains')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('urls', function(Blueprint $table) {
			$table->dropForeign('urls_domain_sitemap_id_foreign');
		});
		Schema::table('scan_scheduler', function(Blueprint $table) {
			$table->dropForeign('scan_scheduler_domain_sitemap_id_foreign');
		});
		Schema::table('domain_sitemap', function(Blueprint $table) {
			$table->dropForeign('domain_sitemap_domain_id_foreign');
		});
	}
}