<?php

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class DomainSitemap extends Eloquent {

	protected $table = 'domain_sitemap';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function scans()
	{
		return $this->hasMany('ScanScheduler');
	}

	public function urls()
	{
		return $this->hasMany('URL');
	}

}