<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateActualitiesTable extends Migration {

	public function up()
	{
		Schema::create('actualities', function(Blueprint $table) {
			$table->increments('id');
			$table->string('slug', 100);
			$table->string('label', 100);
			$table->text('content');
			$table->boolean('published')->default(false);
			$table->boolean('in_slider')->default(true);
			$table->string('picture_name', 80)->nullable();
			$table->integer('created_by')->unsigned()->nullable();
			$table->integer('upated_by')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('actualities');
	}
}