<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePortfoliosTable extends Migration {

	public function up()
	{
		Schema::create('portfolios', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->unique();
			$table->bigInteger('image');
			$table->string('url_link')->nullable();
			$table->bigInteger('profile_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('portfolios');
	}
}