<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProfilesTable extends Migration {

	public function up()
	{
		Schema::create('profiles', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('activity', 70);
			$table->boolean('is_mobile')->default(false);
			$table->boolean('on_full_time')->default(false);
			$table->string('price');
			$table->string('slug')->unique();
			$table->longText('description')->nullable();
			$table->boolean('is_available')->default(true);
			$table->date('availability_date')->nullable();
			$table->boolean('is_verified')->default(false);
			$table->boolean('is_certified')->default(false);
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('town_id')->unsigned();
			$table->bigInteger('experience_year_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('profiles');
	}
}