<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('trades', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('trades')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('trades', function(Blueprint $table) {
			$table->foreign('trade_group_id')->references('id')->on('trade_groups')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('portfolios', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('experiences', function(Blueprint $table) {
			$table->foreign('sector_id')->references('id')->on('sectors')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('experiences', function(Blueprint $table) {
			$table->foreign('town_id')->references('id')->on('towns')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('experiences', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('formations', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('town_id')->references('id')->on('towns')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->foreign('experience_year_id')->references('id')->on('experience_years')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recommendations', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('recommendations', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('author_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->foreign('profile_id')->references('id')->on('profiles')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('trades', function(Blueprint $table) {
			$table->dropForeign('trades_parent_id_foreign');
		});
		Schema::table('trades', function(Blueprint $table) {
			$table->dropForeign('trades_trade_group_id_foreign');
		});
		Schema::table('portfolios', function(Blueprint $table) {
			$table->dropForeign('portfolios_profile_id_foreign');
		});
		Schema::table('experiences', function(Blueprint $table) {
			$table->dropForeign('experiences_sector_id_foreign');
		});
		Schema::table('experiences', function(Blueprint $table) {
			$table->dropForeign('experiences_town_id_foreign');
		});
		Schema::table('experiences', function(Blueprint $table) {
			$table->dropForeign('experiences_profile_id_foreign');
		});
		Schema::table('formations', function(Blueprint $table) {
			$table->dropForeign('formations_profile_id_foreign');
		});
		Schema::table('missions', function(Blueprint $table) {
			$table->dropForeign('missions_user_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_user_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_town_id_foreign');
		});
		Schema::table('profiles', function(Blueprint $table) {
			$table->dropForeign('profiles_experience_year_id_foreign');
		});
		Schema::table('recommendations', function(Blueprint $table) {
			$table->dropForeign('recommendations_author_id_foreign');
		});
		Schema::table('recommendations', function(Blueprint $table) {
			$table->dropForeign('recommendations_profile_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_author_id_foreign');
		});
		Schema::table('favorites', function(Blueprint $table) {
			$table->dropForeign('favorites_profile_id_foreign');
		});
	}
}