<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOperationsTable extends Migration {

	public function up()
	{
		Schema::create('operations', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('implantation_id')->unsigned();
			$table->integer('nature_id')->unsigned();
			$table->integer('productions_status_id')->unsigned();
			$table->integer('support_id')->unsigned();
			$table->integer('type_id')->unsigned();
			$table->string('entry_service', 254);
			$table->string('expected_prod', 254)->nullable();
			$table->float('expected_prod_value')->nullable();
			$table->string('installed_capacity', 254)->nullable();
			$table->float('installed_capacity_value')->nullable();
			$table->string('land_surface', 254)->nullable();
			$table->float('land_surface_value')->nullable();
			$table->string('overall_investment', 254)->nullable();
			$table->float('overall_investment_value')->nullable();
			$table->string('purchase_price', 254);
			$table->float('purchase_price_value')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('operations');
	}
}