<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSheltersTable extends Migration {

	public function up()
	{
		Schema::create('shelters', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('zone_id')->unsigned();
			$table->string('label', 255);
			$table->string('length');
			$table->float('lenght_value');
			$table->string('width');
			$table->float('width_value');
			$table->string('surface');
			$table->string('author', 255);
			$table->float('surface_value');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('shelters');
	}
}