<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSitesTable extends Migration {

	public function up()
	{
		Schema::create('sites', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('city_id')->unsigned();
			$table->integer('country_id')->unsigned();
			$table->integer('region_id')->unsigned();
			$table->string('zip_code', 254);
			$table->string('name', 254);
			$table->string('adress', 254);
			$table->string('latitude', 254);
			$table->string('longitude', 254);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sites');
	}
}