<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDefectCategorizationsTable extends Migration {

	public function up()
	{
		Schema::create('Defect_categorizations', function(Blueprint $table) {
			$table->increments('id');
			$table->float('tolerance1');
			$table->float('tolerance2');
			$table->integer('reference_id')->unsigned();
			$table->integer('defect_type_id')->unsigned();
			$table->integer('confidence_id')->unsigned();
			$table->integer('criticality_id')->unsigned();
			$table->integer('compliance_id')->unsigned();
			$table->integer('check_controle_id')->unsigned();
			$table->string('label', 255);
			$table->string('author', 255);
			$table->integer('controle_points_id')->unsigned();
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('Defect_categorizations');
	}
}