<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateControlesTable extends Migration {

	public function up()
	{
		Schema::create('controles', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('asset_id')->unsigned();
			$table->integer('inspection_frequency_id')->unsigned();
			$table->integer('installation_type_id')->unsigned();
			$table->integer('inspection_id')->unsigned();
			$table->integer('maintenance_type_id')->unsigned();
			$table->integer('related_servicing_id')->unsigned();
			$table->integer('phase_id')->unsigned();
			$table->string('name', 255);
			$table->string('from', 255);
			$table->string('to', 255);
			$table->string('saison', 255);
			$table->string('author', 255);
			$table->string('label', 255);
			$table->softDeletes();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('controles');
	}
}