<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateItemsTable extends Migration {

	public function up()
	{
		Schema::create('items', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->string('code')->unique();
			$table->bigInteger('user_id')->unsigned();
			$table->enum('unit', array('meter', 'quantity'));
			$table->text('description');
		});
	}

	public function down()
	{
		Schema::drop('items');
	}
}