<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuantitiesTable extends Migration {

	public function up()
	{
		Schema::create('quantities', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('item_id')->unsigned();
			$table->integer('request_id')->nullable();
			$table->string('request_type');
			$table->enum('returned_reason', array('faulty', 'operated'))->nullable();
			$table->enum('item_status', array('new', 'used', 'dismantled'));
			$table->string('serial_number')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('quantities');
	}
}